// wiki.js - Wiki route module.

const express = require("express");
const statements = require("../models/statements.js");
const operation = require("../models/clients.js");
const logs = require("../models/logs.js");
const db = require("../models/connection.js");
//const axios = require("axios");
const fs = require('fs');
const path = require('path');
const multer = require("multer");
const router = express.Router();

var storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, 'public/operations/')
  },
  filename: function (req, file, cb) {
    cb(null, file.originalname) //Appending extension
  }
});
// const upload = multer({ storage: storage });
router.post('/createClient',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.client_name != null)
   operation.createClient(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {pID:new_user.pID,subject:"Docket",activityEvent:"Created New Docket"}
              //   logs.createLog(logObj,cons);
              // }
              // catch(err){}

              res.status(200).json({"result":"ok","message":"Client Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});
// const upload = multer({ storage: storage });

router.post('/createClientPlant',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.clientID != null)
   operation.createClientPlant(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {pID:new_user.pID,subject:"Docket",activityEvent:"Created New Docket"}
              //   logs.createLog(logObj,cons);
              // }
              // catch(err){}

              res.status(200).json({"result":"ok","message":"Client Plant Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});


router.post('/createClientRep',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.clientID != null)
   operation.createClientRep(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {pID:new_user.pID,subject:"Docket",activityEvent:"Created New Docket"}
              //   logs.createLog(logObj,cons);
              // }
              // catch(err){}

              res.status(200).json({"result":"ok","message":"Client Rep Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});



router.post('/createDeliveryCompany',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.added_by != null)
   operation.createDeliveryCompany(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {pID:new_user.pID,subject:"Docket",activityEvent:"Created New Docket"}
              //   logs.createLog(logObj,cons);
              // }
              // catch(err){}

              res.status(200).json({"result":"ok","message":"Delivery Company Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});


router.post('/createDeliveryRep',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.added_by != null)
   operation.createDeliveryRep(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {pID:new_user.pID,subject:"Docket",activityEvent:"Created New Docket"}
              //   logs.createLog(logObj,cons);
              // }
              // catch(err){}

              res.status(200).json({"result":"ok","message":"Delivery Rep Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.post('/createDeliveryPlant',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.added_by != null)
   operation.createDeliveryPlant(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {pID:new_user.pID,subject:"Docket",activityEvent:"Created New Docket"}
              //   logs.createLog(logObj,cons);
              // }
              // catch(err){}

              res.status(200).json({"result":"ok","message":"Plant Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.post('/createContract',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.clientID != null)
   operation.createContract(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {pID:new_user.pID,subject:"Docket",activityEvent:"Created New Docket"}
              //   logs.createLog(logObj,cons);
              // }
              // catch(err){}

              res.status(200).json({"result":"ok","message":"Contract Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});


router.post('/updateDeliveryCompany',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.added_by != null)
   operation.updateDeliveryCompany(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {pID:new_user.pID,subject:"Docket",activityEvent:"Created New Docket"}
              //   logs.createLog(logObj,cons);
              // }
              // catch(err){}

              res.status(200).json({"result":"ok","message":"Company Updated Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.post('/updateDeliveryPlant',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.added_by != null)
   operation.updateDeliveryPlant(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {pID:new_user.pID,subject:"Docket",activityEvent:"Created New Docket"}
              //   logs.createLog(logObj,cons);
              // }
              // catch(err){}

              res.status(200).json({"result":"ok","message":"Plant Updated Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});



router.post('/updateDeliveryRep',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.added_by != null)
   operation.updateDeliveryRep(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {pID:new_user.pID,subject:"Docket",activityEvent:"Created New Docket"}
              //   logs.createLog(logObj,cons);
              // }
              // catch(err){}

              res.status(200).json({"result":"ok","message":"Delivery Rep Updated Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.post('/updateContract',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.added_by != null)
   operation.updateContract(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {pID:new_user.pID,subject:"Docket",activityEvent:"Created New Docket"}
              //   logs.createLog(logObj,cons);
              // }
              // catch(err){}

              res.status(200).json({"result":"ok","message":"Contract Updated Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});







const upload = multer({ storage: storage });
router.post('/attachToOperation',upload.array("s_attach"),function(req,res){
  var new_user = req.body;
  if(req.file!=null)
  if(req.files.length > 0){
    new_user['files'] = req.files;
  }
  else{
    new_user['files'] = [];
  }
  var cons = db.connect();

  if(new_user.files != null)
   operation.operationAttach(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {opID:new_user.opID,pID:new_user.pID,subject:"File Upload",activityEvent:"Uploaded Attachments"}
              //   logs.createOperationLog(logObj,cons);
              // }
              // catch(err){}
              res.status(200).json({"result":"ok","message":"File Attached Successfully"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "No Files Attached"});

});



router.get('/getClients/:type/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getClients(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive vehicles"});
       });
});

router.get('/getPlants/:type/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getPlants(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive vehicles"});
       });
});

router.get('/getClientRep/:type/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getClientReps(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive vehicles"});
       });
});




router.get('/getDeliveryCompanies/:type/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
  
   operation.getDeliveryCompanies(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive vehicles"});
       });
});

router.get('/getDeliveryPlants/:type/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getDeliveryPlants(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive vehicles"});
       });
});

router.get('/getDeliveryReps/:type/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getDeliveryReps(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive vehicles"});
       });
});

router.get('/getContracts/:type/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getContracts(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive vehicles"});
       });
});





module.exports = router;



