// wiki.js - Wiki route module.

const express = require("express");
const statements = require("../models/statements.js");
const operation = require("../models/operations.js");
const logs = require("../models/logs.js");
const db = require("../models/connection.js");
//const axios = require("axios");
const fs = require('fs');
const path = require('path');
const multer = require("multer");
const router = express.Router();

var storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, 'public/operations/')
  },
  filename: function (req, file, cb) {
    cb(null, file.originalname) //Appending extension
  }
});
// const upload = multer({ storage: storage });
router.post('/createOperation',function(req,res){
	var new_user = req.body;
  console.log(new_user);
	var cons = db.connect();

  if(new_user.name != null)
	 operation.createOperation(new_user,cons).then((q_res) => {
		        console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              try{
                var logObj = {pID:new_user.pID,subject:"Docket",activityEvent:"Created New Docket"}
                logs.createLog(logObj,cons);
              }
              catch(err){}

              res.status(200).json({"result":"ok","message":"operation Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

	else
		res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});
// const upload = multer({ storage: storage });

router.post('/createOperationNote',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.name != null)
   operation.createOperationNote(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              try{
                var logObj = {opID:new_user.opID,pID:new_user.pID,subject:"Docket Note",activityEvent:"Created New Docket Note"}
                logs.createOperationLog(logObj,cons);
              }
              catch(err){}

              res.status(200).json({"result":"ok","message":"operation Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});


router.post('/createOperationBrief',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.opID != null && new_user.pID != null && new_user.brief != null)
   operation.createOperationBrief(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              try{
                var logObj = {opID:new_user.opID,pID:new_user.pID,subject:"Docket Brief",activityEvent:"Created New Docket Brief"}
                logs.createOperationLog(logObj,cons);
              }
              catch(err){}
              res.status(200).json({"result":"ok","message":"operation Brief Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});



const upload = multer({ storage: storage });
router.post('/attachToOperation',upload.array("s_attach"),function(req,res){
  var new_user = req.body;
  if(req.file!=null)
  if(req.files.length > 0){
    new_user['files'] = req.files;
  }
  else{
    new_user['files'] = [];
  }
  var cons = db.connect();

  if(new_user.files != null)
   operation.operationAttach(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              try{
                var logObj = {opID:new_user.opID,pID:new_user.pID,subject:"File Upload",activityEvent:"Uploaded Attachments"}
                logs.createOperationLog(logObj,cons);
              }
              catch(err){}
              res.status(200).json({"result":"ok","message":"File Attached Successfully"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "No Files Attached"});

});


router.post('/linkStatement',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.opID != null && new_user.stmtID !=null)
   operation.linkStatement(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              try{
                var logObj = {opID:new_user.opID,pID:new_user.pID,subject:"Statement",activityEvent:"Linked Statement to Docket"}
                logs.createOperationLog(logObj,cons);
              }
              catch(err){}
              res.status(200).json({"result":"ok","message":"Statement Linked Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});


router.post('/inviteOfficer',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.opID != null && new_user.pID !=null)
   operation.inviteOfficer(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              try{
                var logObj = {opID:new_user.opID,pID:new_user.pID,subject:"Operation Team",activityEvent:"Invited officer to operation team"}
                logs.createOperationLog(logObj,cons);
              }
              catch(err){}
              res.status(200).json({"result":"ok","message":"Officer Invited Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});


router.post('/assignCharges',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.opID != null && new_user.pID !=null)
   operation.assignCharges(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              try{
                var logObj = {opID:new_user.opID,pID:new_user.pID,subject:"Operation Team",activityEvent:"Invited officer to operation team"}
                logs.createOperationLog(logObj,cons);
              }
              catch(err){}
              res.status(200).json({"result":"ok","message":"Officer Invited Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});



router.post('/modifyOperationTeam',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.opID != null && new_user.ctrlVal !=null)
   operation.removeOperationOfficer(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              if(new_user.ctrlVal == 2){
                try{
                  var logObj = {opID:new_user.opID,pID:new_user.pID,subject:"Operation Team",activityEvent:"Officer Removed From Operation team"}
                  logs.createOperationLog(logObj,cons);
                }
                catch(err){}
                res.status(200).json({"result":"ok","message":"Officer Removed Successfully"});
              }
              else if(new_user.ctrlVal == 1){
                try{
                  var logObj = {opID:new_user.opID,pID:new_user.pID,subject:"Operation Team",activityEvent:"Officer Added From Operation team"}
                  logs.createOperationLog(logObj,cons);
                }
                catch(err){}
                res.status(200).json({"result":"ok","message":"Officer Added Successfully"});
              }
              else if(new_user.ctrlVal == 3){
                try{
                  var logObj = {opID:new_user.opID,pID:new_user.pID,subject:"Operation Team",activityEvent:"Officer Suspended From Operation team"}
                  logs.createLog(logObj,cons);
                }
                catch(err){}
                res.status(200).json({"result":"ok","message":"Officer Suspended Successfully"});
              }
            }
            else if(q_res == 3){              
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.post('/handoverOperation',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.opID != null && new_user.op_level !=null)
   operation.handoverOperation(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"Operation handover Successfully"});
            }
             else if(q_res == 5){
              res.status(200).json({"result":"ok","message":"Operation Not Found"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});


router.post('/transfareOperationAuthority',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.opID != null && new_user.transfare_by !=null)
   operation.transfareOperationAuthority(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"Operation transfare Successfully"});
            }
             else if(q_res == 5){
              res.status(200).json({"result":"ok","message":"Operation Not Found"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});


router.post('/addCharge',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.opID != null && new_user.chargeID !=null)
   operation.addCharge(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"Charges Added Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.get('/dropCharge/:opchID',function(req,res){
  var new_user = req.params;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.opchID != null)
   operation.dropCharge(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"Charges Dropped Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.post('/archiveOperation',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.opID != null)
   operation.archiveOperation(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"Operation Archived Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });
  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.get('/getChargeCategories',function(req,res){
  var cons = db.connect();
  
   operation.getChargeCategories(cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});

router.get('/getCharges/:crcatID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getCharges(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});

router.get('/getOperationCharges/:type/:nID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getOperationCharges(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});

router.get('/getOperations',function(req,res){
  var cons = db.connect();
  var bod = req.query;
  
   operation.getOperations(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});

router.get('/getOperationNotes/:opID/:category',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log("load : ",bod)
   operation.getOperationNotes(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});

router.get('/getOperationBrief/:opID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log("load : ",bod)
   operation.getOperationBrief(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});


router.get('/getOperationNotes/:opntID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log("loading : ",bod)
   operation.getOperationNote(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});

router.get('/getOperationStatements/:opID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log("loading : ",bod)
   operation.getOperationStatements(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});

router.get('/getOperationTeam/:opID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log("loading : ",bod)
   operation.getOperationTeam(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});

router.get('/getPersonCharges/:type/:opID/:ID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log("loading : ",bod)
   operation.getPersonCharges(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});


router.get('/getOperationAttachments/:opID/:category',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log("load : ",bod)
   operation.getOperationAttachments(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});

router.get('/getOperationAttachments/:attID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log("load : ",bod)
   operation.getOperationAttachment(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});

router.get('/getHandoverLog/:opID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log("loading : ",bod)
   operation.getHandoverLog(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});

router.get('/getDropDowns/',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   statements.getRegDropDowns(cons).then((listSongs) => {
      
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});



router.post('/retractStatement',function(req,res){
  var cons = db.connect();
  var bod = req.body;
  
   statements.retractStatement(bod,cons).then((listSongs) => {            
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});



router.get('/getFile/:fileName',function(req,res){
 var cons = db.connect();
 console.log("recieved Path : ",req.query.path);
 try{
      res.sendFile(path.join(__dirname+'/../public/operations/'+req.params.fileName))
 }    
 catch(err){
  console.log("sorry :  ",err);

 }
 
   
});



module.exports = router;



