// wiki.js - Wiki route module.

const express = require("express");
const statements = require("../models/statements.js");
const operation = require("../models/orders.js");
const logs = require("../models/logs.js");
const db = require("../models/connection.js");
//const axios = require("axios");
const fs = require('fs');
const path = require('path');
const multer = require("multer");
const router = express.Router();

var storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, 'public/orders/')
  },
  filename: function (req, file, cb) {
    cb(null, file.originalname) //Appending extension
  }
});


router.post('/createRoute',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.route != null && new_user.added_by != null)
   operation.createRoute(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){

              res.status(200).json({"result":"ok","message":"Route Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.post('/createOrder',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.scheduleID != null && new_user.added_by != null)
   operation.createOrder(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){

              res.status(200).json({"result":"ok","message":"Route Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});
// const upload = multer({ storage: storage });

router.post('/updateOrderAccount',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.orderID != null && new_user.added_by != null)
   operation.updateOrderAccount(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){

              res.status(200).json({"result":"ok","message":"Route Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.post('/updateRouteName',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.routeID != null && new_user.added_by != null)
   operation.updateRouteName(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){

              res.status(200).json({"result":"ok","message":"Route Updated Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.post('/updateOrderStatus',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.orderID != null && new_user.added_by != null)
   operation.updateOrderStatus(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){

              res.status(200).json({"result":"ok","message":"Order Status Updated Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.post('/updateVehicle',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.reg_no != null)
   operation.updateVehicle(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {pID:new_user.pID,subject:"Docket",activityEvent:"Created New Docket"}
              //   logs.createLog(logObj,cons);
              // }
              // catch(err){}

              res.status(200).json({"result":"ok","message":"Vehicle Updated Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});





const upload = multer({ storage: storage });
router.post('/attachToOrder',upload.single("attachments"),function(req,res){
  var new_user = req.body;
  console.log("file : ",req.file);
  if(req.file!=null)
    new_user['path'] = req.file.destination + "" + req.file.originalname
  var cons = db.connect();

  if(new_user.path != null)
   operation.attachToOrder(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {opID:new_user.opID,pID:new_user.pID,subject:"File Upload",activityEvent:"Uploaded Attachments"}
              //   logs.createOperationLog(logObj,cons);
              // }
              // catch(err){}
              res.status(200).json({"result":"ok","message":"File Attached Successfully"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "No Files Attached"});

});






router.get('/getOrders/:type/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getOrders(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive vehicles"});
       });
});

router.get('/getOrderAccount/:type/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getOrderAccount(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive vehicles"});
       });
});

router.get('/getRoutes/:type/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getRoutes(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive vehicles"});
       });
});

router.get('/getRoutes/:type/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getRoutes(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive vehicles"});
       });
});


router.get('/getOrderTrackStats',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getOrderTrackStats(cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive"});
       });
});

router.get('/getOrderTrack/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getOrderTrack(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive"});
       });
});

router.get('/getOrderAttachments/:id/:attID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getOrderAttachments(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive vehicles"});
       });
});


router.get('/getFile/:fileName',function(req,res){
 var cons = db.connect();
 console.log("recieved Path : ",req.query.path);
 try{
      res.sendFile(path.join(__dirname+'/../public/orders/'+req.params.fileName))
 }    
 catch(err){
  console.log("sorry :  ",err);

 }
 
   
});
module.exports = router;