// wiki.js - Wiki route module.

const express = require("express");
const users = require("../models/person.js");
const db = require("../models/connection.js");
//const axios = require("axios");
const fs = require('fs');
const router = express.Router();


router.post('/createEmployee',function(req,res){

	var new_user = req.body;
  //console.log("Recieved Body : ",new_user)
	var cons = db.connect();
	
  if(new_user.id_no != null)
	 users.createEmployee(new_user,cons).then((q_res) => {
		        console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"User Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });
	else
		res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.post('/createLicense',function(req,res){

  var new_user = req.body;
  //console.log("Recieved Body : ",new_user)
  var cons = db.connect();
  
  if(new_user.empID != null)
   users.createLicense(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"License Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });
  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});


router.post('/createSchedule',function(req,res){

  var new_user = req.body;
  //console.log("Recieved Body : ",new_user)
  var cons = db.connect();
  
  if(new_user.added_by != null)
   users.createSchedule(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"Schedule Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });
  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});


router.post('/updateLicense',function(req,res){

  var new_user = req.body;
  //console.log("Recieved Body : ",new_user)
  var cons = db.connect();
  
  if(new_user.driverID != null)
   users.updateLicense(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"License Updated Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });
  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});


router.post('/updateEmployee',function(req,res){
  var new_user = req.body;
  //console.log("Recieved Body : ",new_user)
  var cons = db.connect();
  
  if(new_user.id_no != null)
   users.updateEmployee(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"Person Updated Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });
  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});





router.post('/createCredentials',function(req,res){
  var new_user = req.body;
  //console.log("Recieved Body : ",new_user)
  var cons = db.connect();
  
  if(new_user.username != null && new_user.userpass != null && new_user.pID != null  && new_user.ctrlVal != null )
   users.createCredentials(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Could Not Create Creadentials"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"Credentials Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });
  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});


router.post('/createPosition',function(req,res){
  var new_user = req.body;
  //console.log("Recieved Body : ",new_user)
  var cons = db.connect();
  
  if(new_user.position)
   users.createPosition(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Could Not Create position"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"position Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });
  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.get('/getDropDowns/',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   users.getRegDropDowns(cons).then((listSongs) => {
            //console.log(wholeQue);
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });

});

router.get('/getEmployees/:type/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   users.getEmployees(bod,cons).then((listSongs) => {
          
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });

});

router.get('/getSchedule/:type/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   users.getSchedule(bod,cons).then((listSongs) => {
          
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive Schedules"});
       });

});

router.get('/getAvailableDrivers/:type/:duty_date',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   users.getAvailableDrivers(bod,cons).then((listSongs) => {
          
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive Schedules"});
       });

});

router.get('/getDrivers/:type/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   users.getDrivers(bod,cons).then((listSongs) => {
          
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive Schedules"});
       });

});

router.get('/getPersonsSearch/',function(req,res){
  var cons = db.connect();
  var bod = req.query;
  console.log("recieved : ",bod)
  
   users.getPersonsSearch(bod,cons).then((listSongs) => {
          
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });

});


router.get('/getPositions',function(req,res){
  var cons = db.connect();
  var bod = req.query;
  console.log("recieved : ",bod)
  
   users.getPositions(cons).then((listSongs) => {
          
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });

});




module.exports = router;