// wiki.js - Wiki route module.

const express = require("express");
const search = require("../models/search.js");
const playlists = require("../models/playlists.js");
const db = require("../models/connection.js");
const router = express.Router();

// Home page route.
router.get("/", function (req, res) {
  res.send("playlists home page");
});

// About page route.
router.get("/about", function (req, res) {
  //res.send("About this playlists");
});


router.get('/searchContent/:sestr',function(req,res){
	 var cons = db.connect();
	 search.searchContent(cons,req.params.sestr).then((currentLists) => {
            //console.log(wholeQue);
            res.status(200).json(currentLists);
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "Could not retreive tracks"});
       });
});

router.get('/searchContentLink',function(req,res){
   var cons = db.connect();
   var beleli = req.query.beleli;
   console.log("Search ID : ",beleli);
   search.searchContentLink(cons,beleli).then((currentLists) => {
            //console.log(wholeQue);
            res.status(200).json(currentLists);
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "Could not retreive tracks"});
       });
});

module.exports = router;