// wiki.js - Wiki route module.

const express = require("express");
const statements = require("../models/statements.js");
const db = require("../models/connection.js");
//const axios = require("axios");
const fs = require('fs');
const path = require('path');
const multer = require("multer");
const router = express.Router();
//var insert_attachment = "insert into statement_attachment(stmtntID,path,ctrlVal) values";

var storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, 'public/statements/')
  },
  filename: function (req, file, cb) {
    cb(null, file.originalname) //Appending extension
  }
});
const upload = multer({ storage: storage });
router.post('/createStatement',upload.array("s_attach"),function(req,res){
	var new_user = req.body;
  if(req.files.length > 0){
    new_user['files'] = req.files;
  }
  else{
    new_user['files'] = [];
  }
	var cons = db.connect();

  if(new_user.type != null)
	 statements.createStatement(new_user,cons).then((q_res) => {
		        console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"Statement Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

	else
		res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});






router.get('/getDropDowns/',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   statements.getRegDropDowns(cons).then((listSongs) => {
      
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});

router.get('/getStatements/:type/:pID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   statements.getStatements(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});

router.post('/retractStatement',function(req,res){
  var cons = db.connect();
  var bod = req.body;
  
   statements.retractStatement(bod,cons).then((listSongs) => {            
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});



router.get('/getFile/:fileName',function(req,res){
 var cons = db.connect();
 console.log("recieved Path : ",req.query.path);
 try{
      res.sendFile(path.join(__dirname+'/../public/statements/'+req.params.fileName))
 }    
 catch(err){
  console.log("sorry :  ",err);
 }
 
   
});



module.exports = router;



