// wiki.js - Wiki route module.

const express = require("express");
const stats = require("../models/stats.js");
const db = require("../models/connection.js");
const fs = require('fs');
var misc = require('../com.model/misc.js')
const router = express.Router();


router.get('/liveDocumentStatus',function(req,res){
    var new_obj = req.body;
    console.log("Recieved Body : ",new_obj)
    var cons = db.connect();
  
    stats.liveDocumentStatus(cons).then((stat) => {
            res.status(200).json(stat);
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "fail",message:"Statuses could not be Loaded"});
       });
  
    });


router.get('/localDemoGender',function(req,res){
    
    var cons = db.connect();
  
    stats.localDemoGender(fs,cons).then((stat) => {

        res.status(200).json(stat);
        
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "fail",message:"Statuses could not be Loaded"});
       });
  
    });

router.get('/latestDocuments',function(req,res){
   
    
    var cons = db.connect();
  
    stats.latestDocuments(cons).then((stat) => {
       
            res.status(200).json(stat);
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "fail",message:"Statuses could not be Loaded"});
       });
  
    });

router.get('/loadAnnouncements/:type/:query',function(req,res){
    
    var bod = req.params;
    var cons = db.connect();
  
    stats.loadAnnouncements(bod,cons).then((stat) => {
            res.status(200).json(stat);
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "fail",message:"Announcements could not be Loaded"});
       });
  
    });

router.post('/createAnnouncement',function(req,res){
  var new_user = req.body;
  console.log(new_user);
  var cons = db.connect();

  if(new_user.pID != null)
   stats.createAnnouncement(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"Announcement Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.get('/testDemo',function(req,res){
    
    var cons = db.connect();
  
    stats.testDemo(fs,cons).then((stat) => {


        res.status(200).json(stat);
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "fail",message:"Statuses could not be Loaded"});
       });
  
});

// router.get('/getFeedback/:type/:ID',function(req,res){
//   var cons = db.connect();
//   var bod = req.params;
//   console.log(bod);
//   stats.getFeedback(bod,cons).then((listSongs) => {
//             //console.log(wholeQue);
//             res.status(200).json(listSongs);
//        }).catch((err)=>{
//             console.log(err);
//              res.status(500).json({result : "error",message:"Could not Process Request"});
//        });
   
// });
// router.get('/ticketStats/:type/:ID',function(req,res){
//   var cons = db.connect();
//   var bod = req.params;
//   console.log(bod);
//   stats.ticketStats(bod,cons).then((listSongs) => {
//             //console.log(wholeQue);
//             res.status(200).json(listSongs);
//        }).catch((err)=>{
//             console.log(err);
//            res.status(500).json({result : "error",message:"Could not Process Request"});
//        });
   
// });



// router.get('/systemStats/:type/:role',function(req,res){
//   var cons = db.connect();
//   var bod = req.params;
//     console.log(bod);
//     if(bod.role == "systad")
//         stats.systemStats(bod,cons).then((listSongs) => {
//                 //console.log(wholeQue);
//                 res.status(200).json(listSongs);
//            }).catch((err)=>{
//                 console.log(err);
//                 res.status(500).json({result : "error",message:"Could not Process Request"});
//            });
//     else
//        res.status(200).json({result : "fail",message:"Please Fill In Body"});
   
// });



// router.get('/requestStatus/:userID',function(req,res){
//   var cons = db.connect();
//   var bod = req.params;
//   console.log(bod);
//    stats.requestStatus(bod,cons).then((listSongs) => {
//             //console.log(wholeQue);
//             res.status(200).json(listSongs);
//        }).catch((err)=>{
//             console.log(err);
//             res.status(500).json({result : "error",message:"Could not Process Request"});
//        });
   
// });



// router.get('/getMyQue/:type/:userID/:orgID/:status',function(req,res){
//   var cons = db.connect();
//   var bod = req.params;
//    stats.getMyQue(bod,cons).then((listSongs) => {
//             //console.log(wholeQue);
//             res.status(200).json(listSongs);
//        }).catch((err)=>{
//             console.log(err);
//             res.status(500).json({result : "Could not retreive Organisazions"});
//        });
   
// });



// router.post('/recieveOnline',function(req,res){
//      var bod = req.body;
//      var cons = db.connect2();
//      console.log(bod)
//      //console.log("Service Len : ",bod[2].Services.length)
//      var i=0;
//      var req_que = [];
//      if(bod[0].ID.length == bod[1].Phone.length && bod[2].Services.length == bod[1].Phone.length )
//           for(;i<bod[0].ID.length;i++){
//                req_que.push({userID:bod[0].ID[i],phone:bod[1].Phone[i],services:bod[2].Services[i],req_no:bod[3].Request[i]});
//                //if((i + 1)==bod[0].)
//           }
//      var last = stats.latestNumberMutliT(fs,req_que,cons)
//      res.status(200).json({result : "ok",last:last});
      
// });


module.exports = router;