// wiki.js - Wiki route module.

const express = require("express");
const users = require("../models/users.js");
const db = require("../models/connection.js");
const axios = require("axios");
const fs = require('fs');
const router = express.Router();


router.post('/createAccount',function(req,res){
	var new_user = req.body;
  console.log("Recieved Body : ",new_user)
	var cons = db.connect();
	if(new_user.id_number != null && new_user.phone != null && new_user.surname != null && new_user.first_name != null && new_user.email != null && new_user.password != null )
	 users.createUser(new_user.id_number,new_user.phone,new_user.surname,new_user.first_name,new_user.email,new_user.user_role,new_user.password,cons).then((q_res) => {
		        console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              res.status(200).json({"result":"ok","message":"Account Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });
	else
		res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});

router.post('/authUser',function(req,res){
  var cons = db.connect();
  var bod = req.body;
  if(bod.email != null && bod.password != null){
   users.authUser(bod,cons).then((listSongs) => {
            //console.log(wholeQue);
            res.status(200).json(listSongs);
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({result : "Could not retreive playlists"});
       });
   }
   else {
    res.status(500).json({result : "fail",message:"Please fill in all details"});
   }
});


router.post('/muteAccountState',function(req,res){
  var cons = db.connect();
  var bod = req.body;
  if(bod.userID != null && bod.userID > 0 && bod.status != null){
   users.muteAccountState(bod,cons).then((listSongs) => {
            //console.log(wholeQue);
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
   }
   else {
    res.status(500).json({result : "fail",message:"Please fill in all details"});
   }
});



router.get('/changeS1/:userID/:email',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  if(bod.userID != null && bod.userID > 0 && bod.email != null){
   users.changeS1(bod,cons).then((listSongs) => {
            //console.log(wholeQue);
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
   }
   else {
    res.status(500).json({result : "fail",message:"Please fill in all details"});
   }
});


router.post('/changePassword',function(req,res){
  var cons = db.connect();
  var bod = req.body;
  if(bod.userID != null && bod.email != null && bod.password != null){
   users.changePassword(bod,cons).then((listSongs) => {
         
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "error",message:"Could not Process Request"});
       });
   }
   else {
    res.status(500).json({result : "fail",message:"Please fill in all details"});
   }
});

router.get('/forgotS1/:email',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  console.log("Inside Request");
  let rawdata = fs.readFileSync('./states/resetState.json');
  let resets = JSON.parse(rawdata);
  let pool = [1,2,3,4,5,6,7,8,9]; 
  var i=0;
  var id_build = "";

  var  min = Math.ceil(0);
  var max = Math.floor(9);
  for(;i<5;i++){
     var pick = pool[parseInt((Math.random()* (max - min) + min))];
     id_build += ""+pick;
     console.log(pick," picked ----- ","Current build : ",id_build)
  }
  var message = "<h2>Reset Code : "+id_build+"</h2>";
  var subject = "Password Reset";

  resets.reset.push({email:bod.email,reset:parseInt(id_build),reset_code:0});

   fs.writeFileSync('./states/resetState.json',JSON.stringify(resets));
    


  axios.get("http://services.myquicksheets.com/mailer/sendMail.php?notifID=0&lastName=&firstName=&mailing="+bod.email+"&message="+message+"&subject="+subject+"&org=org&adminSupport=")
    .then(response => {         
            console.log(response);
            res.status(200).json({result : "ok",message:response.data});
    })
  .catch(error => {
      console.error('There was an error!', error);
      res.status(500).json({result : "error",message:"Mailing Error"});
  });
  //res.status(200).json({result : resets});

        
 });


router.get('/forgotS2/:email/:reset',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
  let rawdata = fs.readFileSync('./states/resetState.json');
  let resets = JSON.parse(rawdata);
  var ii=0;
  var ved=false;
  while(ii<resets.reset.length){

    if(resets.reset[ii].email == bod.email && resets.reset[ii].reset == bod.reset){
      console.log("Reseted :", resets.reset[ii])
      ved=true;
      break;

    }
    else{
      console.log("Failed :", resets.reset[ii])
    }
    ii++;

}
  let pool = [1,2,3,4,5,6,7,8,9]; 
  var i=0;
  var id_build = "";

  var  min = Math.ceil(0);
  var max = Math.floor(9);
  for(;i<8;i++){
     var pick = pool[parseInt((Math.random()* (max - min) + min))];
     id_build += ""+pick;
     console.log(pick," picked ----- ","Current build : ",id_build)
  }
  var message = "Reset Code : "+id_build;
  var subject = "Password Reset";
if(ved){
  resets.reset[ii]["reset_code"] = parseInt(id_build);

  fs.writeFileSync('./states/resetState.json',JSON.stringify(resets));
  res.status(200).json({result : "ok",message:"Otp Corrrect",reset_code:id_build});
}
else{
  res.status(200).json({result : "fail",message:"Otp Incorrrect Or Has Expired",reset_code:0});
}
  

        
 });


router.post('/resetPassword',function(req,res){
  var cons = db.connect();
  var bod = req.body;

  console.log(bod)
  let rawdata = fs.readFileSync('./states/resetState.json');
  let resets = JSON.parse(rawdata);
  var ii=0;
  var ved = false;
  while(ii<resets.reset.length){

    if(resets.reset[ii].email == bod.email && resets.reset[ii].reset_code == bod.reset_code){
      console.log("Reseted :", resets.reset[ii])
      ved = true;
      break;
    }
    else{
      console.log("Failed :", resets.reset[ii])
    }
    ii++;

  }

  if(bod.email != null && bod.new_password != null && ved){
   users.changePassword(bod,cons).then((listSongs) => {
         
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "error",message:"Could not Process Request"});
       });
   }
   else {
    res.status(500).json({result : "fail",message:"Please fill in all details"});
   }
});



  // if(bod.userID != null && bod.userID > 0 && bod.email != null){
  //  users.changeS1(bod,cons).then((listSongs) => {
  //           //console.log(wholeQue);
  //         res.status(200).json(listSongs);
  //      }).catch((err)=>{
  //         console.log(err);
  //         res.status(500).json({result : "Could not retreive playlists"});
  //      });
  //  }
  //  else {
  //   res.status(500).json({result : "fail",message:"Please fill in all details"});
  //  }
//});





module.exports = router;