// wiki.js - Wiki route module.

const express = require("express");
const statements = require("../models/statements.js");
const operation = require("../models/vehicle.js");
const logs = require("../models/logs.js");
const db = require("../models/connection.js");
//const axios = require("axios");
const fs = require('fs');
const path = require('path');
const multer = require("multer");
const router = express.Router();

var storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, 'public/operations/')
  },
  filename: function (req, file, cb) {
    cb(null, file.originalname) //Appending extension
  }
});
// const upload = multer({ storage: storage });
router.post('/createVehicle',function(req,res){
	var new_user = req.body;
  console.log(new_user);
	var cons = db.connect();

  if(new_user.reg_no != null)
	 operation.createVehicle(new_user,cons).then((q_res) => {
		        console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {pID:new_user.pID,subject:"Docket",activityEvent:"Created New Docket"}
              //   logs.createLog(logObj,cons);
              // }
              // catch(err){}

              res.status(200).json({"result":"ok","message":"Vehicle Created Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

	else
		res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});
// const upload = multer({ storage: storage });

router.post('/updateVehicle',function(req,res){
	var new_user = req.body;
  console.log(new_user);
	var cons = db.connect();

  if(new_user.reg_no != null)
	 operation.updateVehicle(new_user,cons).then((q_res) => {
		        console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {pID:new_user.pID,subject:"Docket",activityEvent:"Created New Docket"}
              //   logs.createLog(logObj,cons);
              // }
              // catch(err){}

              res.status(200).json({"result":"ok","message":"Vehicle Updated Successfully"});
            }
            else if(q_res == 3){
              res.status(200).json({"result":"fail","message":"Email Already Exists, Please try Another Email"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

	else
		res.status(500).json({"result" : "error", "message" : "Please Fill In All Fields"});

});





const upload = multer({ storage: storage });
router.post('/attachToOperation',upload.array("s_attach"),function(req,res){
  var new_user = req.body;
  if(req.file!=null)
  if(req.files.length > 0){
    new_user['files'] = req.files;
  }
  else{
    new_user['files'] = [];
  }
  var cons = db.connect();

  if(new_user.files != null)
   operation.operationAttach(new_user,cons).then((q_res) => {
            console.log("Adding Result : ",q_res);
            if(q_res == -1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 1){
              res.status(200).json({"result":"fail","message":"Server Error"});
            }
            else if(q_res == 2){
              // try{
              //   var logObj = {opID:new_user.opID,pID:new_user.pID,subject:"File Upload",activityEvent:"Uploaded Attachments"}
              //   logs.createOperationLog(logObj,cons);
              // }
              // catch(err){}
              res.status(200).json({"result":"ok","message":"File Attached Successfully"});
            }
            
       }).catch((err)=>{
            console.log(err);
            res.status(500).json({"result" : "error","message":"Server Error, Couldn't Process Request"});
       });

  else
    res.status(500).json({"result" : "error", "message" : "No Files Attached"});

});






router.get('/getVehicles/:type/:id',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getVehicles(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive vehicles"});
       });
});

router.get('/getCharges/:crcatID',function(req,res){
  var cons = db.connect();
  var bod = req.params;
  
   operation.getCharges(bod,cons).then((listSongs) => {
          res.status(200).json(listSongs);
       }).catch((err)=>{
          console.log(err);
          res.status(500).json({result : "Could not retreive playlists"});
       });
});






module.exports = router;



